#include "DEditBox.h"

namespace DWL {


    //
    //! Funcin para crear un control EditBox
    //  HWND Crear(const long Estilos, HWND hWndPadre, const TCHAR *Text, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID);
    HWND DEditBox::Crear(DBaseWnd *nPadre, const TCHAR *Text, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, const DWORD nEstilos) {
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
		_hWnd = CreateWindow(TEXT("EDIT"), Text, nEstilos, cX, cY, cAncho, cAlto, nPadre->hWnd(), reinterpret_cast<HMENU>(IntToPtr(cID)), GetModuleHandle(NULL), NULL);
		_ConectarControl(cID, nPadre);
        return _hWnd;
	};

	//
	//! Funcin para asignar un EditBox ya creado en un Dialogo
	//  void Asignar(HWND hWndPadre, const int ID_Control);
    HWND DEditBox::Asignar(DBaseWnd *nPadre, const UINT cID) {
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
		_hWnd = GetDlgItem(nPadre->hWnd(), cID);
		_ConectarControl(cID, nPadre);
		return _hWnd;
	};

    //
	//! Funcin que retorna el texto de este control
	//  void ObtenerTexto(DString &nTexto);
    void DEditBox::ObtenerTexto(DString &nTexto) {
        int Tam = GetWindowTextLength(_hWnd);
        if (Tam > 0) {
            TCHAR *TmpStr = new TCHAR[Tam + 1];
			GetDlgItemText(GetParent(_hWnd), ID(), TmpStr, Tam + 1);
            nTexto = TmpStr;
            delete [] TmpStr;
        }
        else {
            nTexto.Borrar();
        }
	};

    LRESULT CALLBACK DEditBox::GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam) {
        switch (uMsg) {
			case WM_LBUTTONUP :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_CLICK_IZQUIERDO, ID(), lParam);
				break;
			case WM_RBUTTONUP :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_CLICK_DERECHO, ID(), lParam);
				break;
			case WM_MBUTTONUP :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_CLICK_MEDIO, ID(), lParam);
				break;
			case WM_LBUTTONDBLCLK :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_DOBLECLICK_IZQUIERDO, ID(), 0);
				break;
			case WM_RBUTTONDBLCLK :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_DOBLECLICK_DERECHO, ID(), 0);
				break;
			case WM_MBUTTONDBLCLK :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_DOBLECLICK_MEDIO, ID(), 0);
				break;
			case WM_KEYDOWN :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_TECLADO_PRESIONADO, wParam, (LPARAM)ID());
				break;
			case WM_KEYUP :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_TECLADO_SOLTADO, wParam, (LPARAM)ID());
				if (wParam == 13) {
					PostMessage(GetParent(_hWnd), DWL_EDITBOX_TECLADO_INTRO, wParam, (LPARAM)ID());
				}
				break;
			case WM_SETFOCUS :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_FOCO_OBTENIDO, ID(), 0);
				break;
			case WM_KILLFOCUS :
				PostMessage(GetParent(_hWnd), DWL_EDITBOX_FOCO_PERDIDO, ID(), 0);
				break;   
        }
        return DBaseControlWin::GestorMensajes(uMsg, wParam, lParam);
    }
};